-- New ArkhamBooks Database script for MySQL Server
-- Modified 16 June 2010

DROP TABLE IF EXISTS ab_type;
DROP TABLE IF EXISTS ab_orders;
DROP TABLE IF EXISTS ab_orderdetail;
DROP TABLE IF EXISTS ab_author;
DROP TABLE IF EXISTS ab_wrote;
DROP TABLE IF EXISTS ab_customer;
DROP TABLE IF EXISTS ab_publisher;
DROP TABLE IF EXISTS ab_title;



-- Create Type table and insert records
create table ab_type
(Type     varchar(15)    not null   primary key) engine=InnoDb ;


INSERT INTO ab_type
VALUES ('Travel');

INSERT INTO ab_type
VALUES ('Fantasy');

INSERT INTO ab_type
VALUES ('Programming');

INSERT INTO ab_type
VALUES ('Children');

INSERT INTO ab_type
VALUES ('Cooking');

INSERT INTO ab_type
VALUES ('Art');

INSERT INTO ab_type
VALUES ('Gothic');

INSERT INTO ab_type
VALUES ('Horror');

INSERT INTO ab_type
VALUES ('Mystery');

INSERT INTO ab_type
VALUES ('Non Fiction');

INSERT INTO ab_type
VALUES ('Romance');

INSERT INTO ab_type
VALUES ('Science Fiction');

INSERT INTO ab_type
VALUES ('Fantasy Gaming');

INSERT INTO ab_type
VALUES ('Modern Gaming');


-- create Publisher table and insert records
create table ab_publisher
(PubId     int auto_increment not null   primary key,
 Name   varchar(30)  not null,
 Address varchar(30),
 City   varchar(20),
 State  char(2),
 Zip    varchar(10),
 Contact varchar(20)) engine=InnoDb;


INSERT INTO ab_publisher(Name, Address, City, State, Zip, Contact)
VALUES
('Prentice Hall', '345 Pine',
    'Englewood Cliffs', 'NJ', '07632', NULL);

INSERT INTO ab_publisher(Name, Address, City, State, Zip, Contact)
 VALUES
('Atheneum Books', '1230 Avenue of the Americas', 
     'New York', 'NY', '10020', 'Debbie Johnson');

INSERT INTO ab_publisher(Name, Address, City, State, Zip, Contact)
 VALUES
('Mysterious Press', '386 Park Avenue South', 
       'New York', 'NY', '10016', 'Kim Richards');

INSERT INTO ab_publisher(Name, Address, City, State, Zip, Contact)
 VALUES
('Greenwillow Books', '67 Park Avenue West', 
      'New York', 'NY', '10023', 'Jody');

INSERT INTO ab_publisher (Name, Address, City, State, Zip, Contact)
VALUES
('Henry Holt and Company', '115 West 18th Street', 
      'New York', 'NY', '10111', 'John Wagner');

INSERT INTO ab_publisher(Name, Address, City, State, Zip, Contact)
 VALUES
('Sunset Books', 'One Sunset Plaza', 
      'Menlo Park', 'CA', '93547', 'Jim');

INSERT INTO ab_publisher(Name, Address, City, State, Zip, Contact)
VALUES
('Thomas Nelson Publishers', '22 Twain Place', 
      'Nashville', 'TN', '65789', 'Bob');

INSERT INTO ab_publisher (Name, Address, City, State, Zip, Contact)
VALUES
('Arkham House Publishers', 'P.O. Box 546', 
      'Sauk City', 'WI', '53583', 'August D');

INSERT INTO ab_publisher (Name, Address, City, State, Zip, Contact)
VALUES
('Berkley Publisher Group', '1289 2nd Street', 
       'New York', 'NY', '10247', 'John');

INSERT INTO ab_publisher (Name, Address, City, State, Zip, Contact)
VALUES
('Del Rey', '258 Broadway', 
       'New York', 'NY', '10023', NULL);

INSERT INTO ab_publisher (Name, Address, City, State, Zip, Contact)
VALUES
('Tor Fantasy', '2789 First Ave.', 
        'San Francisco', 'CA', '95687', 'Fred');

INSERT INTO ab_publisher(Name, Address, City, State, Zip, Contact)
VALUES
('Viking Press', '26 Nordic Way', 
        'New York', 'NY', '10054', NULL);

INSERT INTO ab_publisher (Name, Address, City, State, Zip, Contact)
VALUES
('Prime Crime', '1 Mystery Lane', 
        'Sleepy Hollow', 'NY', '11203', 'Katrina');

INSERT INTO ab_publisher (Name, Address, City, State, Zip, Contact)
VALUES
('Fawcett Books', 'One Park Place', 
        'New York', 'NY', '10029', 'Andy');

INSERT INTO ab_publisher (Name, Address, City, State, Zip, Contact)
VALUES
('Harper Torch', 'Two Firebrand Lane', 
        'Chicago', 'IL', '68974', 'Mary');

INSERT INTO ab_publisher (Name, Address, City, State, Zip, Contact)
VALUES
('Thomson Learning', 'One Technology Park', 
         'Boston', 'MA', '02210', 'Jennifer');

INSERT INTO ab_publisher (Name, Address, City, State, Zip, Contact)
VALUES
('Apress', '2560 Ninth Street, Suite 219', 
         'Berkeley', 'CA', '94710', 'James');

INSERT INTO ab_publisher (Name, Address, City, State, Zip, Contact)
VALUES
('White Wolf Publishing', '1554 Litton Drive', 
         'Stone Mountain', 'GA', '30083', 'Bob');




-- create Title table and insert records
create table ab_title
(Isbn          varchar(13)       primary key,
 Title         varchar(50)    not null,
 PubId        int     
                               references ab_publisher(PubId),
 Type          varchar(15)  references ab_type(Type),
 QtyOnHand    int,
 Cost          decimal(6,2),
 SellingPrice decimal(6,2)) engine=InnoDb;
 
 


INSERT INTO ab_title VALUES
('0131103628', 'The C Programming Language', 
 1, 'Programming', 6, 30.00, 39.95);

INSERT INTO ab_title VALUES
('9781595097774', 'Beginning C# 2005 Databases', 
 17, 'Programming', 10, 28.00, 39.99);

INSERT INTO ab_title VALUES
('0140296301', 'Aunt Dimity''s Christmas', 
 12, 'Mystery', 4, 4.00, 5.95);
                              
INSERT INTO ab_title VALUES
('0345345991', 'Crewel Lye', 
 10, 'Fantasy', 4, 4.00, 7.50);

INSERT INTO ab_title VALUES
('0345453751', 'The Sword of Shannara Trilogy', 
 10, 'Fantasy', 10, 12.00, 24.95);

INSERT INTO ab_title VALUES
('0345470389', 'On the Night of the Seventh Moon', 
 14, 'Romance', 1, 5.00, 6.95);

INSERT INTO ab_title VALUES
('0376050187', 'Back Roads and Hidden Places', 
 6, 'Travel', 2, 10.00, 12.50);

INSERT INTO ab_title VALUES
('0380820749', 'The Ivy Tree', 
 15, 'Gothic', 4, 4.00, 6.99);

INSERT INTO ab_title VALUES
('0380820765', 'Nine Coaches Waiting', 
 15, 'Gothic', 6, 4.00, 5.99);

INSERT INTO ab_title VALUES
('0385006009', 'The Legend of the Seventh Virgin', 
 14, 'Romance', 5, 10.00, 15.98);

INSERT INTO ab_title VALUES
('0425140989', 'Thyme of Death', 
 9, 'Mystery', 4, 3.50, 6.95);

INSERT INTO ab_title VALUES
('0425144062', 'Witches'' Bane', 
 9, 'Mystery', 5, 3.50, 6.95);

INSERT INTO ab_title VALUES
('042519129X', 'The English Breakfast Murder', 
 13, 'Mystery', 4, 4.25, 6.95);

INSERT INTO ab_title VALUES
('0425193993', 'A Dilly of a Death', 
 9, 'Mystery', 2, 9.00, 16.95);

INSERT INTO ab_title VALUES
('0425198138', 'The Jasmine Moon Murder', 
 13, 'Mystery', 7, 10.00, 16.95);

INSERT INTO ab_title VALUES
('0445406518', 'Crocodile on the Sandbank', 
 3, 'Mystery', 10, 4.00, 6.75);

INSERT INTO ab_title VALUES
('0446363383', 'The Last Camel Died at Noon', 
 3, 'Mystery', 4, 4.00, 6.75);

INSERT INTO ab_title VALUES
('0449214222', 'A Walk in Wolf Wood', 
 15, 'Gothic', 7, 10.00, 14.95);

INSERT INTO ab_title VALUES
('0449242463', 'Snowfire', 
 14, 'Romance', 8, 5.00, 7.50);

INSERT INTO ab_title VALUES
('0619016620', 'Programming with Visual Basic .Net', 
 16, 'Programming', 5, 15.00, 26.00);

INSERT INTO ab_title VALUES
('0670032786', 'Aunt Dimity Snowbound', 
 12, 'Mystery', 10, 4.00, 5.95);

INSERT INTO ab_title VALUES
('0688010377', 'Airs Above the Ground', 
 15, 'Gothic', 2, 5.00, 7.95);

INSERT INTO ab_title VALUES
('0688092101', 'Brrr!', 
 4, 'Children', 4, 4.00, 5.25);

INSERT INTO ab_title VALUES
('0689318960', 'A City Under the Sea', 
 2, 'Children', 10, 4.00, 4.95);

INSERT INTO ab_title VALUES
('0785269606', 'A Village Christmas', 
 7, 'Art', 23, 21.00, 24.95);

INSERT INTO ab_title VALUES
('0805015825', 'Winter Wheat', 
 5, 'Children', 0, 3.50, 5.95);

INSERT INTO ab_title VALUES
('0812574990', 'Up in a Heaval', 
 11, 'Fantasy', 9, 5.00, 7.50);

INSERT INTO ab_title VALUES
('0870541757', 'Dragonfly', 
 8, 'Fantasy', 8, 12.00, 22.75);

INSERT INTO ab_title VALUES
('0870541781', 'In The Stone House', 
 8, 'Science Fiction', 2, 20.00, 32.50);

INSERT INTO ab_title VALUES
('0870541811', 'The Cleansing', 
 8, 'Horror', 7, 27.00, 32.50);

INSERT INTO ab_title VALUES
('1878252186', 'Shadows over Innsmouth', 
 8, 'Horror', 20, 27.00, 29.95);

INSERT INTO ab_title VALUES
('1878252402', 'Whispers in the Night', 
 8, 'Horror', 2, 30.00, 34.50);

INSERT INTO ab_title VALUES
('9781558464903', 'World of Darkness: Book of Spirits', 
 18, 'Modern Gaming', 7, 16.00, 26.95);

INSERT INTO ab_title VALUES
('9781558464910', 'World of Darkness: Asylum', 
 18, 'Modern Gaming', 5, 16.00, 26.95);



-- create Author table and insert records
create table ab_author
(AuthorId     int  not null  auto_increment      primary key,
 LastName   varchar(20)      not null,
 FirstName  varchar(15)) engine=InnoDb;
 

INSERT INTO ab_author(LastName, FirstName)
VALUES ('King', 'Stephen');

INSERT INTO ab_author(LastName, FirstName)
VALUES ('Ritchie', 'Dennis');

INSERT INTO ab_author(LastName, FirstName)
VALUES ('Wu', 'Norbert');

INSERT INTO ab_author(LastName, FirstName)
VALUES ('Peters', 'Elizabeth');

INSERT INTO ab_author(LastName, FirstName)
VALUES ('Stevenson', 'James');

INSERT INTO ab_author(LastName, FirstName)
VALUES ('Kinkade', 'Thomas');

INSERT INTO ab_author(LastName, FirstName)
VALUES ('Guiberson', 'Brenda');

INSERT INTO ab_author(LastName, FirstName)
VALUES ('Braasch', 'Barbara');

INSERT INTO ab_author(LastName, FirstName)
VALUES ('Cooper', 'Basil');

INSERT INTO ab_author(LastName, FirstName)
VALUES ('Campbell', 'Ramsey');

INSERT INTO ab_author(LastName, FirstName)
VALUES ('Harvey', 'John');

INSERT INTO ab_author(LastName, FirstName)
VALUES ('Anthony', 'Piers');

INSERT INTO ab_author(LastName, FirstName)
VALUES ('Brooks', 'Terry');

INSERT INTO ab_author(LastName, FirstName)
VALUES ('Albert', 'Susan');

INSERT INTO ab_author(LastName, FirstName)
VALUES ('Malzberg', 'Barry');

INSERT INTO ab_author(LastName, FirstName)
VALUES ('Durbin', 'Federic');

INSERT INTO ab_author(LastName, FirstName)
VALUES ('Atherton', 'Nancy');

INSERT INTO ab_author(LastName, FirstName)
VALUES ('Childs', 'Laura');

INSERT INTO ab_author(LastName, FirstName)
VALUES ('Stewart', 'Mary');

INSERT INTO ab_author(LastName, FirstName)
VALUES ('Whitney', 'Phyllis');

INSERT INTO ab_author(LastName, FirstName)
VALUES ('Holt', 'Victoria');

INSERT INTO ab_author(LastName, FirstName)
VALUES ('Zak', 'Diane');

INSERT INTO ab_author(LastName, FirstName)
VALUES ('Huddleston', 'James');

INSERT INTO ab_author(LastName, FirstName)
VALUES ('Dembski-Bowden', 'Aaron');


-- create Wrote table and insert records
create table ab_wrote
(AuthorId       int           
                                        references ab_author(AuthorId),
 Isbn            varchar(13)            
                                        references ab_title(Isbn),
 Sequence    tinyint,
  primary key (AuthorId, Isbn)) engine=InnoDb;

INSERT INTO ab_wrote 
VALUES (2, '0131103628', 1);

INSERT INTO ab_wrote  
VALUES (3, '0689318960', 1);

INSERT INTO ab_wrote  
VALUES (4, '0445406518', 1);

INSERT INTO ab_wrote  
VALUES (4, '0446363383', 1);

INSERT INTO ab_wrote  
VALUES (5, '0688092101', 1);

INSERT INTO ab_wrote  
VALUES (6, '0785269606', 1);

INSERT INTO ab_wrote  
VALUES (7, '0805015825', 1);

INSERT INTO ab_wrote  
VALUES (8, '0376050187', 1);

INSERT INTO ab_wrote  
VALUES (9, '1878252402', 1);

INSERT INTO ab_wrote  
VALUES (10, '1878252186', 1);

INSERT INTO ab_wrote  
VALUES (11, '0870541811', 1);

INSERT INTO ab_wrote  
VALUES (12, '0345345991', 1);

INSERT INTO ab_wrote  
VALUES (12, '0812574990', 1);

INSERT INTO ab_wrote  
VALUES (13, '0345453751', 1);

INSERT INTO ab_wrote  
VALUES (14, '0425140989', 1);

INSERT INTO ab_wrote  
VALUES (14, '0425144062', 1);

INSERT INTO ab_wrote  
VALUES (14, '0425193993', 1);

INSERT INTO ab_wrote  
VALUES (15, '0870541781', 1);

INSERT INTO ab_wrote  
VALUES (16, '0870541757', 1);

INSERT INTO ab_wrote  
VALUES (17, '0140296301', 1);

INSERT INTO ab_wrote  
VALUES (17, '0670032786', 1);

INSERT INTO ab_wrote  
VALUES (18, '042519129X', 1);

INSERT INTO ab_wrote  
VALUES (18, '0425198138', 1);

INSERT INTO ab_wrote  
VALUES (19, '0380820749', 1);

INSERT INTO ab_wrote  
VALUES (19, '0380820765', 1);

INSERT INTO ab_wrote  
VALUES (19, '0449214222', 1);

INSERT INTO ab_wrote  
VALUES (19, '0688010377', 1);

INSERT INTO ab_wrote  
VALUES (20, '0449242463', 1);

INSERT INTO ab_wrote  
VALUES (21, '0345470389', 1);

INSERT INTO ab_wrote  
VALUES (21, '0385006009', 1);

INSERT INTO ab_wrote 
VALUES (22, '0619016620', 1);

INSERT INTO ab_wrote 
VALUES (23, '9781595097774', 1);

INSERT INTO ab_wrote 
VALUES (24, '9781558464910', 1);

INSERT INTO ab_wrote 
VALUES (24, '9781558464903', 1);


-- create Customer table and insert records
create table ab_customer
(CustId        int  not null auto_increment           primary key,
 LastName      varchar(20)      not null,
 FirstName     varchar(15)     not null,
 Address        varchar(30),
 City           varchar(20),
 State          char(2),
 Zip            varchar(10),
 Phone          char(12),
 Email	       varchar(35),
 CardType      varchar(16),
 CardNumber	    varchar(16),
 CardExpire     varchar(5)) engine=InnoDb;
 



INSERT INTO ab_customer(LastName, FirstName, Address, City, State, Zip, Phone, Email, CardType, CardNumber, CardExpire) 
VALUES
('Richardson', 'John', '1524 Center Dr.', 'La Mesa', 'CA', '91945', '619-358-6578',
'jrich@cox.net', 'Visa', '4224369865742591', '03/07');

INSERT INTO ab_customer(LastName, FirstName, Address, City, State, Zip, Phone, Email, CardType, CardNumber, CardExpire) 
VALUES
('Lolan', 'Bobbi', '122 Elysian Fields', 'New Orleans', 'LA', '73401', '704-987-6421',
'blolan@no.rr.net', 'Master Card', '5623326598754128', '02/05');

INSERT INTO ab_customer(LastName, FirstName, Address, City, State, Zip, Phone, Email, CardType, CardNumber, CardExpire) 
VALUES
('Smith', 'Tim', '12597 1st Ave.', 'Chula Vista', 'CA', '92174', '619-658-8794',
'tsmith@sbcglobal.net', 'Discover', '6598234568710954', '04/06');

INSERT INTO ab_customer(LastName, FirstName, Address, City, State, Zip, Phone, Email, CardType, CardNumber, CardExpire) 
VALUES
('Edwards', 'Mitch', '19872 Pine Court', 'Kansas City', 'MO', '69877', '648-987-0938',
'mitch@earthnet.com', 'American Express', '370044875669745', '10/04');

INSERT INTO ab_customer(LastName, FirstName, Address, City, State, Zip, Phone, Email, CardType, CardNumber, CardExpire) 
VALUES
('Brown', 'Edward', '14598 Poway Road', 'Poway', 'CA', '92064', '858-486-6897',
'ebrown@hobo.net', 'Master Card', '5236698756824712', '09/05');

INSERT INTO ab_customer(LastName, FirstName, Address, City, State, Zip, Phone, Email, CardType, CardNumber, CardExpire) 
VALUES
('Rowland', 'Mike', '32657 Jasmine Place', 'Park City', 'UT', '86987', '236-568-9874',
'roland@hotmail.com', 'Visa', '4225639856875214', '12/04');

INSERT INTO ab_customer(LastName, FirstName, Address, City, State, Zip, Phone, Email, CardType, CardNumber, CardExpire) 
VALUES
('Perkins', 'Anthony', '235 Circle Dr.', 'La Mesa', 'CA', '91942', '247-986-3274',
'psycho@bates.com', 'Master Card', '5668213659875897', '12/05');

INSERT INTO ab_customer(LastName, FirstName, Address, City, State, Zip, Phone, Email, CardType, CardNumber, CardExpire) 
VALUES
('Jones', 'Ralph', '2 Shady Lane', 'Chula Vista', 'CA', '92105', '254-987-2327',
'shady@nightmare.com', 'Discover', '6987986215476387', '01/07');



-- create the Orders table and insert records
create table ab_orders
(OrderId      int not null auto_increment      primary key,
 OrderDate    datetime,
 CustId       int      
                                  references ab_customer(CustId),
 CardType      varchar(16),
 CardNumber	   varchar(16),
 CardExpire    varchar(5)) engine=InnoDb;
 
INSERT INTO ab_orders(OrderDate, CustId, CardType, CardNumber, CardExpire)
 VALUES
('2003/09/10', 1, 'Visa', '4224369869563521', '07/07');

INSERT INTO ab_orders(OrderDate, CustId, CardType, CardNumber, CardExpire) 
VALUES
('2003/10/10', 2, 'American Express', '370044875669745', '06/05');

INSERT INTO ab_orders(OrderDate, CustId, CardType, CardNumber, CardExpire)
 VALUES
('2003/12/17', 2, 'American Express', '370044875669745', '06/05');

INSERT INTO ab_orders(OrderDate, CustId, CardType, CardNumber, CardExpire) 
VALUES
('2004/01/12', 1, 'Visa', '4224369869563521', '07/07');

INSERT INTO ab_orders(OrderDate, CustId, CardType, CardNumber, CardExpire) 
VALUES
('2004/01/24', 4, 'Discover', '6987326528742587', '02/06');

INSERT INTO ab_orders(OrderDate, CustId, CardType, CardNumber, CardExpire) 
VALUES
('2004/02/29', 5, 'Master Card', '5365879658752414', '03/08');

INSERT INTO ab_orders(OrderDate, CustId, CardType, CardNumber, CardExpire) 
VALUES
('2004/03/02', 6, 'Master Card', '5224369865214785', '01/06');

INSERT INTO ab_orders (OrderDate, CustId, CardType, CardNumber, CardExpire)
VALUES 
('2004/03/10', 6, 'Master Card', '5224369865214785', '01/06');

INSERT INTO ab_orders(OrderDate, CustId, CardType, CardNumber, CardExpire) 
VALUES
('2004/04/23', 2, 'American Express', '370044875669745', '06/05');

INSERT INTO ab_orders(OrderDate, CustId, CardType, CardNumber, CardExpire)
VALUES
('2004/05/14', 5, 'Master Card', '5365879658752414', '03/08');

INSERT INTO ab_orders(OrderDate, CustId, CardType, CardNumber, CardExpire) 
VALUES
('2004/05/14', 4, 'Discover', '6987326528742587', '02/06');

INSERT INTO ab_orders(OrderDate, CustId, CardType, CardNumber, CardExpire) 
VALUES
('2004/05/20', 1, 'Visa', '4224369869563521', '07/07');



-- create the orderdetail table and insert records
create table ab_orderdetail
(OrderId       int      not null       
                                          references ab_orders(OrderId),
 Isbn           varchar(13) not null        
                                          references ab_title(Isbn),
 Qty    int,
 Price  decimal(6,2),
  primary key (OrderId, Isbn)) engine=InnoDb;


INSERT INTO ab_orderdetail VALUES
(1, '0870541811', 1, 32.50);

INSERT INTO ab_orderdetail VALUES
(1, '0870541781', 1, 32.50);

INSERT INTO ab_orderdetail VALUES
(2, '0449242463', 1, 6.75);

INSERT INTO ab_orderdetail VALUES
(3, '0425198138', 2, 15.26);

INSERT INTO ab_orderdetail VALUES
(3, '0380820765', 1, 5.39);

INSERT INTO ab_orderdetail VALUES
(4, '0140296301', 1, 5.95);

INSERT INTO ab_orderdetail VALUES
(5, '0345470389', 1, 5.56);

INSERT INTO ab_orderdetail VALUES
(6, '0345345991', 3, 7.13);

INSERT INTO ab_orderdetail VALUES
(6, '0345453751', 1, 23.70);

INSERT INTO ab_orderdetail VALUES
(7, '0688010377', 1, 7.95);

INSERT INTO ab_orderdetail VALUES
(8, '0670032786', 2, 5.95);

INSERT INTO ab_orderdetail VALUES
(8, '0812574990', 1, 7.50);

INSERT INTO ab_orderdetail VALUES
(9, '0131103628', 1, 35.96);

INSERT INTO ab_orderdetail VALUES
(9, '0619016620', 1, 23.40);

INSERT INTO ab_orderdetail VALUES
(10, '1878252402', 1, 32.78);

INSERT INTO ab_orderdetail VALUES
(11, '0785269606', 1, 19.96);

INSERT INTO ab_orderdetail VALUES
(12, '0449214222', 1, 14.95);

INSERT INTO ab_orderdetail VALUES
(12, '0688010377', 2, 7.95);
